from django.shortcuts import render
from django.http import HttpResponse
from .models import *
from django.http import HttpResponse
from openpyxl import Workbook
from openpyxl.styles import Alignment
from .models import Activity



def home(request):
    return render(request,'home/home.html')


def send_activity(request):
    activity_form = ActivityForm(request.POST)
    if request.method == 'POST':
        if activity_form.is_valid():
            data = activity_form.cleaned_data
            Activity.objects.create(date=data['date'],ObservationsfromBodyScan=data['ObservationsfromBodyScan'],flexibility=data['flexibility'],musclestrengthdone=data['musclestrengthdone'],equilibrion=data['equilibrion'],walking=data['walking'],respiration=data['respiration'],stressed=data['stressed'],
                                    ObservationsfromBreathingActivity=data['ObservationsfromBreathingActivity'],ObservationsfromFractionalBreathing=data['ObservationsfromFractionalBreathing'],ObservationsfromWalkingMeditation=data['ObservationsfromWalkingMeditation'],
                                    WalkingMonday=data['WalkingMonday'],WalkingTuesday=data['WalkingTuesday'],WalkingWendsday=data['WalkingWendsday'],WalkingThursday=data['WalkingThursday'],WalkingFriday=data['WalkingFriday'],
                                    WalkingSaterday=data['WalkingSaterday'],WalkingSunday=data['WalkingSunday'],ActivityMonday=data['ActivityMonday'],ActivityTuesday=data['ActivityTuesday'],
                                    ActivityWendsday=data['ActivityWendsday'],ActivityThursday=data['ActivityThursday'],ActivityFriday=data['ActivityFriday'],ActivitySaterday=data['ActivitySaterday'],
                                    ActivitySunday=data['ActivitySunday'],Breakfast=data['Breakfast'],Lunch=data['Lunch'],Dinner=data['Dinner'],MiddleDaySnack=data['MiddleDaySnack'],OutofMeal=data['OutofMeal'],
                                    Supplement=data['Supplement'],user_id=request.user.id)
    return render(request,'home/activity.html',{'activity_form':activity_form})


def diet(request):
    return render(request,'home/diet.html')


def example(request):
    return render(request,'home/example.html')    


def equi(request):
    return render(request,'home/equi.html')


def flexibility(request):
    return render(request,'home/flexibility.html')



def calendar(request, week=None):
    return render(request,'home/calendar.html', {'week': week})



def muscle(request):
    return render(request,'home/muscle.html')

def raspi(request):
    return render(request,'home/raspi.html')


def stomia(request):
    return render(request,'home/stomia.html')


def train(request):
    return render(request,'home/train.html')


def worry(request):
    return render(request,'home/worry.html')                   




def activity_daily(request,id):
        return render(request,'home/home.html')


def export_activity_to_excel(request, user_id):
    activities = Activity.objects.filter(user_id=user_id)

    wb = Workbook()
    ws = wb.active
    ws.title = "Activity Data"

    headers = [
        'Date', 'Flexibility', 'Muscle Strength Done', 'Equilibrium', 'Walking',
        'Respiration', 'Stressed', 'Observations from Body Scan', 'Observations from Breathing Activity',
        'Observations from Fractional Breathing', 'Observations from Walking Meditation',
        'Walking Monday', 'Walking Tuesday', 'Walking Wednesday', 'Walking Thursday', 'Walking Friday',
        'Walking Saturday', 'Walking Sunday', 'Activity Monday', 'Activity Tuesday', 'Activity Wednesday',
        'Activity Thursday', 'Activity Friday', 'Activity Saturday', 'Activity Sunday',
        'Breakfast', 'Lunch', 'Dinner', 'Middle Day Snack', 'Out of Meal', 'Supplement'
    ]
    ws.append(headers)

    column_widths = [15] * len(headers)
    for i, width in enumerate(column_widths):
        ws.column_dimensions[chr(65 + i)].width = width

    for activity in activities:
        row = [
            activity.date, activity.flexibility, activity.musclestrengthdone, activity.equilibrion,
            activity.walking, activity.respiration, activity.stressed, activity.ObservationsfromBodyScan,
            activity.ObservationsfromBreathingActivity, activity.ObservationsfromFractionalBreathing,
            activity.ObservationsfromWalkingMeditation, activity.WalkingMonday, activity.WalkingTuesday,
            activity.WalkingWendsday, activity.WalkingThursday, activity.WalkingFriday, activity.WalkingSaterday,
            activity.WalkingSunday, activity.ActivityMonday, activity.ActivityTuesday, activity.ActivityWendsday,
            activity.ActivityThursday, activity.ActivityFriday, activity.ActivitySaterday, activity.ActivitySunday,
            activity.Breakfast, activity.Lunch, activity.Dinner, activity.MiddleDaySnack, activity.OutofMeal,
            activity.Supplement
        ]
        ws.append(row)

    response = HttpResponse(content_type='application/vnd.openxmlformats-officedocument.spreadsheetml.sheet')
    response['Content-Disposition'] = f'attachment; filename=activity_data_user_{user_id}.xlsx'

    wb.save(response)
    return response